using Microsoft.VisualBasic;
using System;
using MicroFour.StrataFrame.Business;
//using StrataFlix.Business.ApplicationQueries;


namespace StrataFlix.Reporting
{
	namespace Reports
	{
		namespace PeopleProfileReport
		{
			
			
			public class PeopleProfileDataSource : StrataFlix.Reporting.ReportDataSource<PeopleBBS>
			{
				
				
				/// <summary>
				/// Populate the people that will be inclusive of this report
				/// </summary>
				/// <returns></returns>
				/// <remarks></remarks>
				public override bool PopulateDataSource()
				{
					//-- Estalish Locals
					StrataFlix.UI.BrowseDialogs.PeopleBrowseDialog peopleBrw = new StrataFlix.UI.BrowseDialogs.PeopleBrowseDialog();
					
					//-- Set the business object to populate
					peopleBrw.BusinessObjectToPopulate = this.DataSource.SourceBO;
					
					//-- Only bring back the selected record
					peopleBrw.ReturnSelectedRecordOnly = true;
					
					//-- Show the dialog
					if (peopleBrw.ShowDialog() == System.Windows.Forms.DialogResult.OK)
					{
						//-- Get the data sets for the report
						BusinessLayer.FillMultipleDataTables(StrataFlix.Business.ApplicationQueries.PeopleMaintenance_AllData(this.DataSource.SourceBO.pl_pk, false), this.DataSource.SourceBO.MovieCast.SourceBO, this.DataSource.SourceBO.PeopleImages.SourceBO);
						
						//-- Set the report information
						this.LocalReport.DisplayName = "People Profile";
						this.LocalReport.ReportEmbeddedResource = "StrataFlix.Reporting.Reports.People_Profile_Report.PeopleProfile.rdlc";
						
						//-- Create the LocalReport data sources
						this.LocalReport.DataSources.Add(new Microsoft.Reporting.WinForms.ReportDataSource("Source", this.DataSource));
						this.LocalReport.DataSources.Add(new Microsoft.Reporting.WinForms.ReportDataSource("MovieCast", this.DataSource.SourceBO.MovieCast));
						
						return true;
					}
					else
					{
						return false;
					}
				}
				
			}
			
		}
	}
}
